﻿/**
 * @defgroup plugins_importexport_quickSubmit_js
 */
/**
 * @file plugins/importexport/quickSubmit/js/QuickSubmitFormHandler.js
 *
 * Copyright (c) 2014-2017 Simon Fraser University Library
 * Copyright (c) 2000-2017 John Willinsky
 * Distributed under the GNU GPL v2. For full terms see the file docs/COPYING.
 *
 * @class QuickSubmitFormHandler.js
 * @ingroup plugins_importexport_quickSubmit_js
 *
 * @brief Handle the quickSubmit form.
 */
(function ($) {

	$.pkp.plugins.importexport.quickSubmit =
			$.pkp.plugins.importexport.quickSubmit ||
			{ js: {} };



	/**
	 * @constructor
	 *
	 * @extends $.pkp.controllers.form.FormHandler
	 *
	 * @param {jQueryObject} $form the wrapped HTML form element.
	 * @param {Object} options form options.
	 */
	$.pkp.plugins.importexport.quickSubmit.js.QuickSubmitFormHandler =
			function ($form, options) {

		this.parent($form, options);
		this.callbackWrapper(this.updateSchedulePublicationDiv_());

	};
	$.pkp.classes.Helper.inherits(
			$.pkp.plugins.importexport.quickSubmit.js.QuickSubmitFormHandler,
			$.pkp.controllers.form.FormHandler);


	/**
	 * Callback to replace the element's content.
	 *
	 * @private
	 */
	$.pkp.plugins.importexport.quickSubmit.js.QuickSubmitFormHandler.prototype.
			updateSchedulePublicationDiv_ = function () {

		$('input[type=radio][name=articleStatus]').change(function () {
			if ($(this).is(':checked') && this.value == '0') {
				$('#schedulePublicationDiv').hide();
			} else if ($(this).is(':checked') && this.value == '1') {
				$('#schedulePublicationDiv').show();
			} else {
				$('#schedulePublicationDiv').hide();
			}
		});

		$('input[type=radio][name=articleStatus]').trigger('change');

		$('#issueId').change(function () {
			var val, array;
			val = /** @type {string} */ $('#issuesPublicationDates').val();
			array = JSON.parse(val);
			if (!array[$('#issueId').val()]) {
				$('#schedulingInformationDatePublished').hide();
			} else {
				$('input[name="datePublished"]').
						datepicker('setDate', array[$('#issueId').val()]);
				$('#ui-datepicker-div').hide();
				$('#schedulingInformationDatePublished').show();
			}
		});

		$('#issueId').trigger('change');
	};

	/** @param {jQuery} $ jQuery closure. */
}(jQuery));
