<?php

/**
 * @file plugins/importexport/native/filter/NativeExportFilter.inc.php
 *
 * Copyright (c) 2014-2017 Simon Fraser University
 * Copyright (c) 2000-2017 John Willinsky
 * Distributed under the GNU GPL v2. For full terms see the file docs/COPYING.
 *
 * @class NativeExportFilter
 * @ingroup plugins_importexport_native
 *
 * @brief Base class that converts a DataObject to a Native XML document
 */

import('lib.pkp.plugins.importexport.native.filter.NativeImportExportFilter');

class NativeExportFilter extends NativeImportExportFilter {

	/** @var boolean If set to true no validation (e.g. XML validation) will be done */
	var $_noValidation = null;
	
	
	/**
	 * Constructor
	 * @param $filterGroup FilterGroup
	 */
	function __construct($filterGroup) {
		parent::__construct($filterGroup);
	}

	/**
	 * Set no validation option
	 * @param $noValidation boolean
	 */
	function setNoValidation($noValidation) {
		$this->_noValidation = $noValidation;
	}

	/**
	 * Get no validation option
	 * @return boolean true|null
	 */
	function getNoValidation() {
		return $this->_noValidation;
	}

	//
	// Public methods
	//
	/**
	 * @copydoc Filter::supports()
	 */
	function supports(&$input, &$output) {
		// Validate input
		$inputType =& $this->getInputType();
		$validInput = $inputType->isCompatible($input);

		// If output is null then we're done
		if (is_null($output)) return $validInput;

		// Validate output
		$outputType =& $this->getOutputType();

		$validOutput = $outputType->isCompatible($output, $this->getNoValidation());

		return $validInput && $validOutput;
	}
}

?>
