# Settings

1. Introduction
2. [Journal](settings.md#context)
3. [Website](settings.md#website)
4. [Workflow](settings.md#workflow)
5. [Distribution](settings.md#distribution)

Configure your site to suit your needs.

You can access the Settings pages by clicking on the **Settings** link in the main navigation menu on the left, then selecting the specific settings page you'd like.

*Only Journal Managers and Administrators can access and edit the settings.*

There's a lot to be uncovered here. While we're improving this documentation, we've provided a quick overview of what each settings page is for, and detailed break-outs for the trickiest options.

## <a name="context"></a>Journal

Enter basic details about the journal, including the journal name, a short description, the masthead, contact information, and the sections the journal publishes.

**Sections** allow journals to publish submissions to different sections of the journal, such as Reviews and Articles.

## <a name="website"></a>Website

Configure the appearance of your reader-facing website, including logo upload, homepage configuration, sidebar management and more.

You can also set up your site's languages, archiving settings, install and enable plugins, send out announcements and draft key information blocks for visitors.

## <a name="workflow"></a>Workflow

Configure all aspects of the [Editorial Workflow](editorial-workflow.md), including file management, submission guidelines and requirements, peer review deadlines and guidelines, email notifications and much more.

Some of the key settings are broken down in detail below.

### <a name="workflow-components"></a>Components

Your publication files may consist of a number of components, including a article text, research materials, data sets and more.

When authors and editors upload files to a submission, they will be asked to identify the component of this file.

The Components tab provides a list of common components by default. You are encouraged to add or edit components to suit the particular needs of your journal.

Delete those that aren't appropriate for your journal. This will reduce the options faced by authors struggling through their first submission.

### <a name="workflow-submission"></a>Submission
Set your submission guidelines here. You can also modify the submission checklist, which all authors must agree to for their submission.

Submission Metadata allows you to select which types of metadata you wish to track in your journal, and which metadata fields you wish to present to authors upon their submission.

### <a name="workflow-review"></a>Review
From here, you can set all of your review policies and procedures, including deadlines, notifications, guidelines, etc.

### <a name="workflow-library"></a>Publisher Library

The Publisher Library provides a file repository for storing and quickly sharing common files, such as writing guidelines, author contracts and release forms, and marketing materials.

Items that are stored in the Publisher Library can be quickly retrieved and added into a [Submission Library](editorial-workflow.md#submission-library) to be shared with authors or assistants.

### <a name="workflow-emails"></a>Emails

OJS sends a number of emails during various stages of the [Editorial Workflow](editorial-workflow.md), as well as other actions such as registration and submission acknowledgement.

The settings in this section allow you to edit the signature attached to each email, as well as change the default messages sent for each type of email.

If you're unsure what a particular email is for, spin out it's context menu by clicking the toggle to the left of the email, and then click **Edit Email**. Most emails include a short description of when they're sent.

*If you want to restore an email template to it's default, use the __Reset__ link to restore the default message.*

## <a name="distribution"></a>Distribution

Configure settings related to your search engine indexing, any payments if you're taking them, and permissions and licensing details for publications.

In the Permissions tab, you'll find settings for asserting copyright and author licensing.

### <a name="copyright-v-license"></a> What's the difference between Copyright and a License?

The copyright identifies the author or owner of copyright for a published work. For example, Copyright (c) 2016 by Jane Smith.

The license attached to a work will determine the usage rights for the published work. For example, CC-By 4.0 allows the work to be copied, redistributed and adapted for any purpose, even commercially, as long as attribution is given to the copyright holder.
